# 🚀 SpaceBox Pre-Release Checklist

This checklist ensures a stable, professional release of the SpaceBox macOS app.

## ✅ Core Functionality

- [ ] Undo/Redo system works reliably
  - [ ] Object creation undo/redo confirmed
  - [ ] Object movement undo/redo confirmed
  - [ ] Object deletion undo/redo confirmed
  - [ ] Undo stack limited to 20 steps
  - [ ] Redo stack clears correctly after new actions
  - [ ] No duplicate states in the undo stack
  - [ ] Level recalculations (updateRelativeLevels) confirmed after undo/redo

- [ ] File save/load system
  - [ ] Manual Save As… works
  - [ ] Manual Open… works
  - [ ] Autosave and restore on launch tested
  - [ ] Corrupt file handling tested (app does not crash)

- [ ] Snapshot recall functions correctly
  - [ ] Recall triggers undo snapshot
  - [ ] Undo/redo work after snapshot recall

## ✅ UI / User Experience

- [ ] Menu items work correctly
  - [ ] Undo (⌘Z)
  - [ ] Redo (⇧⌘Z)
  - [ ] Save, Save As…, Open
  - [ ] "New Blank Canvas" clears correctly
  - [ ] Dynamic menu states (disable/enable) confirmed

- [ ] Splash screen shows on first launch (if required)

- [ ] Mixer window opens and operates correctly

- [ ] Error handling
  - [ ] Invalid file loads show an alert
  - [ ] Network errors handled gracefully
  - [ ] Deauthorise flow tested

## ✅ Technical / Build

- [ ] Test app on clean machine (no Xcode, no developer tools)

- [ ] App is code signed
  - [ ] Developer ID Application certificate used

- [ ] App is notarized
  - [ ] Upload to Apple notarization service successful
  - [ ] Gatekeeper does not block app launch

- [ ] App icon and branding correct
  - [ ] App icon visible in Finder and Dock
  - [ ] App name, version, and bundle identifier confirmed

- [ ] App version incremented

- [ ] Clean build: remove unused assets and resources

## ✅ Optional Polish

- [ ] Undo/Redo menu shows dynamic titles (e.g., "Undo Move Object")

- [ ] Instruments run for memory leaks and performance

- [ ] Visual feedback for undo/redo (optional: animation or indicator)

- [ ] Confirm app sandbox entitlements (if future sandboxing desired)

## ✅ Final Notes

- [ ] Confirm license/credits (if applicable)
- [ ] Confirm backup of release version
- [ ] Optional: Prepare simple user manual or "What's New" document
- [ ] Optional: Beta testers confirm no critical issues

---

